function cb_m55 
% Menu 55
% Display pickup data table

  global isCancelMeasurement; 
  global persParamsDir
  global puDataDir 
  global puzFname
  global sfontsize
  global m55
  global hdt
  
  capt = get(m55,'label'); 
  
  fpath = uigetdir(puDataDir,capt);  
  
  if (fpath ~= 0);
    
    isCancelMeasurement = true; 
    
    puDataDir=strcat(fpath,'/');
    sn = strcat(persParamsDir,'puDirFname.mat');
    save('-mat',sn,'puDataDir', 'puzFname'); 
    
    % Scan puDataDir and collect pickup data
    
    ds=dir(puDataDir);    
    k=1;
    data={};
    for i=1:length(ds)
      if ~ds(i).isdir
        idx = strfind(ds(i).name,'.pup');
        if ~isempty(idx)
           load(strcat(puDataDir,ds(i).name),'-mat');
           mzpname=strrep(ds(i).name,'.pup','.mzp');
           load(strcat(puDataDir,mzpname),'-mat');
           data{k,1}=planename;          
           data{k,2}=num2str(R0/1000,4);
           data{k,3}=num2str(C0/1e-12,4);
           data{k,4}=num2str(Ls(1),4);
           data{k,5}=num2str(Rs(1)/1000,4);
           data{k,6}=num2str(Ls(2),4);
           data{k,7}=num2str(Rs(2)/1000,4);
           data{k,8}=num2str(Ls(3),4);
           data{k,9}=num2str(Rs(3)/1000,4);
           data{k,10}=num2str(rmse,2);rmse;           
           data{k,11}=num2str(rmseZcal,2);          
           if isGitLoad >0.5
             data{k,12}='yes';
           else
              data{k,12}='no';
           end
          data{k,13}=measDate;          
           k=k+1; 
        end        
      end
    end
    
    % Display pickup data table 
    
    kw=sfontsize/20;
    
    col_names = { 'Pickup Name' 'R0 / kOhm' 'C0 / pF' 'L1 / H ' 'R1 / kOhm' ...
                 'L2 / H' 'R2 / kOhm' 'L3 / H' 'R3 / kOhm' ....
                 'Appr. Error / dB', 'Cal. Error / dB' 'isGitLoad', ...
                  'Date of measurement'};
   col_widths ={kw*300 kw*130 kw*100 kw*100 kw*130 kw*100 ....
                kw*130 kw*100 kw*130 kw*200 kw*200 kw*120 kw*250};
    
    hdt=uitable();
    set(hdt,'units','normalized');
    set(hdt,'position',[0 0 1 1]); 
    set(hdt,'fontsize',9);    
    set(hdt,'ColumnName',col_names); 
    set(hdt,'ColumnWidth',col_widths);
    
    set(hdt,'Data',data); 
    
    
    nc=length(col_names);
    % Save table to ".csv" file
    
    sdate={};
    for m=1:nc-1;
      sdata{1,m}=strcat(col_names{1,m},',');      
    end 
    sdata{1,nc}=col_names{1,nc};
    
    for i = 1:k-1      
      for m=1:nc-1;
        sdata{i+1,m}=strcat(data{i,m},',');
      end
      sdata{i+1,nc}=data{i,nc};
    end
  
    csvname = strcat(puDataDir,'Pickup Data Table.csv');
    fid = fopen(csvname, 'w'); 
    if fid >= 0
      for i=1:k        
        fprintf(fid,'%s',sdata{i,:});
        fprintf(fid,'%s\n','');
      end
      fclose(fid);
    end
    
  end
  
end